/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class GenerationPiece {
    private final List<BlockPart> blockPieces = Lists.newArrayList();
    private final BiPredicate<LevelAccessor, BlockPart> blockPlaceCondition;

    public GenerationPiece(BiPredicate<LevelAccessor, BlockPart> blockPlaceCondition) {
        this.blockPlaceCondition = blockPlaceCondition;
    }

    public void addBlockPiece(BlockState state, BlockPos pos) {
        this.blockPieces.add(new BlockPart(state, pos));
    }

    public boolean canPlace(LevelAccessor level) {
        for (BlockPart blocks : this.blockPieces) {
            if (this.blockPlaceCondition.test(level, blocks)) continue;
            return false;
        }
        return true;
    }

    public void place(LevelAccessor level) {
        for (BlockPart blocks : this.blockPieces) {
            level.m_7731_(blocks.pos, blocks.state, 2);
        }
    }

    public void tryToPlace(LevelAccessor level) {
        if (this.canPlace(level)) {
            this.place(level);
        }
    }

    public static class BlockPart {
        public final BlockState state;
        public final BlockPos pos;

        public BlockPart(BlockState state, BlockPos pos) {
            this.state = state;
            this.pos = pos;
        }
    }
}

